from bpy.types import Panel
from ...addon.naming import FluidLabNaming
from ..ui_module_panel import FLUIDLAB_ModulePanel
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.common_ui_elements import title_header, collapsable
from ...addon.paths import FluidLabPreferences



class FLUIDLAB_PT_export_import_ui(Panel, FLUIDLAB_ModulePanel):
    fluidlab_section = 'EXPORT_IMPORT'
    bl_idname = "FLUIDLAB_PT_export_import_ui"
    bl_label = "Module"

    def draw(self, context):

        fluid_mesh, ui, toggles = get_common_vars(context, get_fluid_mesh=True, get_ui=True, get_toggles=True)

        layout = self.layout
        layout.use_property_split = True
        layout.use_property_decorate = False

        col = layout.column(align=True)
        title_header(col, "Export/Import")

        main_col = col.box().column(align=True)
        main_col.use_property_split = True
        main_col.use_property_decorate = False

        if ui.ui_mode == 'BASIC':
        
            # ------------- #
            """ UI BASICA """
            # ------------- #
        
            main_col.label(text="Hola Mundo Basico")

    
        elif ui.ui_mode == 'ADVANCED':
        
            # --------------- #
            """ UI AVANZADA """
            # --------------- # 
            
            if fluid_mesh.is_void:
                main_col.box().label(text=FluidLabNaming.NO_MESHES_AVAIL, icon='INFO')
            else:
                main_col.template_list("FLUIDLAB_UL_draw_fluids_mesh", "", fluid_mesh, "list", fluid_mesh, "list_index", rows=3)
                exp_bts = main_col.row(align=True)
                exp_bts.scale_y = 1.3
                exp_bts.operator("fluidlab.export_abc", text="Export to Alembic")
                # exp_bts.operator("fluidlab.export_usd", text="Export to USD")
                exp_bts.operator("fluidlab.export_obj", text="Export to single OBJ")

                main_col.separator()

                addon_preferences = FluidLabPreferences.get_prefs(context)
                fpath = addon_preferences.exports_path
                if not fpath:
                    main_col.prop(addon_preferences, "exports_path")

                checkboxes = main_col.column(align=True)
                checkboxes.use_property_split = False
                checkboxes.prop(ui, "auto_import", text="Auto import after export")
                
                if ui.auto_import:
                    checkboxes.prop(ui, "hide_original_mesh", text="Hide original mesh")

                # export_obj = main_col.row(align=True) 
                # export_obj.scale_y = 1.3
                # export_obj.operator("fluidlab.export_obj", text="Export selected object in OBJ")